% --------------------------------------------------------------
% Pade approximation for s(omega)
% --------------------------------------------------------------
function [poles, res] = Pade(omega, s, l, n)

% Arguments:
%    omega = the array of the independent frequency
%    s     = the function of omega to be Pade approximated as 
%            the ratio of polynomials P(omega)/Q(omega)
%    l     = discrete index of center frequency
%    n     = degree of polynomials P and Q
% Returns:
%    poles = the poles of the Pade approximation
%    res   = the residues of the Pade approximation

% Setup the matrix for computing coefficients of P and Q
A = zeros(2*n+1);       
for i = 1:2*n+1
  % Shift frequencies
  oshift(i) = omega(l-1-n+i)-omega(l);     
  
  % P entries
  for k = 1:n+1
    A(i,k) = oshift(i)^(k-1);              
  end

  % Q entries
  for k = 1:n
    A(i,n+1+k) = -s(l-1-n+i)*oshift(i)^k;  
  end

  % Q_0 set to 1
  x(i) = s(l-1-n+i);                       
end

% Compute the coefficients
coef = (A\(x.')).';

for k = 1:n+1
  P(k) = coef(n+2-k);
end

for k = 1:n
  Q(k) = coef(2*n+2-k);
end
Q(n+1) = 1;

% Find the poles and the residues
[res, poles] = residue(P, Q);
poles        = poles + omega(l);  % Restore the frequency shift
